/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import oracle.i18n.text.OraBoot;
import oracle.i18n.util.GDKOracleMetaData;
import oracle.i18n.util.OraLocaleInfo;

public class SortedCommonLocales
implements Serializable {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    private static final HashMap m_objCache = new HashMap();
    private static final String GLBDIR = GDKOracleMetaData.getDataPath();
    public static final String FILENAME_PREFIX = "sortedCommonLocales_";
    protected Locale[] locArray;

    private void SortedCommonLocales() {
    }

    public static synchronized SortedCommonLocales getInstance(String string) {
        String string2 = string.toUpperCase(Locale.US);
        SortedCommonLocales sortedCommonLocales = (SortedCommonLocales)m_objCache.get(string2);
        if (sortedCommonLocales != null) {
            return sortedCommonLocales;
        }
        String string3 = GLBDIR + FILENAME_PREFIX + string + ".glb";
        sortedCommonLocales = (SortedCommonLocales)OraBoot.readObj(string3);
        if (sortedCommonLocales != null) {
            m_objCache.put(string2, sortedCommonLocales);
        }
        return sortedCommonLocales;
    }

    public Locale[] getSortedCommonLocales() {
        return this.locArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.locArray.length);
        for (int i = 0; i < this.locArray.length; ++i) {
            objectOutputStream.writeUTF(this.locArray[i].toString());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        this.locArray = new Locale[n];
        for (n = 0; n < this.locArray.length; ++n) {
            this.locArray[n] = OraLocaleInfo.getLocaleFromString(objectInputStream.readUTF());
        }
    }
}

